<?php require_once "/var/www/html/config.database.php"; ?>
<?php
require_once __DIR__ . '/config.php';
header('Content-Type: application/json');

$db = fxh_db();
if(!$db){ echo json_encode(['status'=>'error']); exit; }

$raw = file_get_contents("php://input");
$j = json_decode($raw, true);
if(!$j){ echo json_encode(['status'=>'error']); exit; }

$license = $j['license'] ?? '';
if($license==''){ echo json_encode(['status'=>'error']); exit; }

$stmt = $db->prepare("
INSERT INTO fxh_trade_logs
(license_key, mt5_account, ticket, symbol, type, volume,
 open_price, close_price, profit, open_time, close_time, sl, tp, comment)
VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)
");

$stmt->bind_param(
    "siissdddddsssss",
    $license,
    $j['account'],
    $j['ticket'],
    $j['symbol'],
    $j['type'],
    $j['volume'],
    $j['open_price'],
    $j['close_price'],
    $j['profit'],
    $j['open_time'],
    $j['close_time'],
    $j['sl'],
    $j['tp'],
    $j['comment']
);

$stmt->execute();

echo json_encode(['status'=>'ok']);
?>
