<?php require_once "/var/www/html/config.database.php"; ?>
<?php
// ==================================================
//  FXHUNTER — STORE EVENT LOG (FINAL VERSION)
// ==================================================

header("Content-Type: text/plain");

// Basic confirmation this script is running
echo "STORE_EVENT IS RUNNING\n";
echo "__FILE__ = " . __FILE__ . "\n\n";

// Enable error reporting (development mode)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Load DB connector
require_once __DIR__ . "/config_webhook.php";



// --------------------------------------------------
// 1) Allow ONLY POST
// --------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo "INVALID_METHOD";
    exit;
}


// --------------------------------------------------
// 2) DEBUG CAPTURE — php://input + POST ARRAY
// --------------------------------------------------
file_put_contents(
    __DIR__ . "/event_debug.txt",
    "=====================\n" .
    "TIME: " . date("Y-m-d H:i:s") . "\n" .
    "RAW_POST: " . file_get_contents("php://input") . "\n" .
    "POST_ARRAY: " . print_r($_POST, true) . "\n\n",
    FILE_APPEND
);


// --------------------------------------------------
// 3) Parse INPUT (URL-encoded)
// --------------------------------------------------
$raw = file_get_contents("php://input");
$data = [];
parse_str($raw, $data);

// If MT5 sent data using $_POST instead of raw-body
if (empty($data) && !empty($_POST)) {
    $data = $_POST;
}


// --------------------------------------------------
// 4) Validate required fields
// --------------------------------------------------
$required = [
    'license_key',
    'mt5_account',
    'symbol',
    'event_type',
    'price',
    'volume',
    'message'
];

foreach ($required as $f) {
    if (!isset($data[$f]) || $data[$f] === "") {
        http_response_code(400);
        echo "MISSING_FIELD: $f";
        exit;
    }
}


// --------------------------------------------------
// 5) Insert into database
// --------------------------------------------------
$sql = "INSERT INTO fxh_event_logs
        (license_key, mt5_account, symbol, event_type, price, volume, message, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, NOW())";

$stmt = $db->prepare($sql);

if (!$stmt) {
    http_response_code(500);
    echo "PREPARE_ERROR: " . $db->error;
    exit;
}

$ok = $stmt->bind_param(
    "sissdds",
    $data['license_key'],
    $data['mt5_account'],
    $data['symbol'],
    $data['event_type'],
    $data['price'],
    $data['volume'],
    $data['message']
);

if (!$ok) {
    http_response_code(500);
    echo "BIND_ERROR: " . $stmt->error;
    exit;
}

$ok = $stmt->execute();

if (!$ok) {
    http_response_code(500);
    echo "EXECUTE_ERROR: " . $stmt->error;
    exit;
}


// --------------------------------------------------
// 6) Success
// --------------------------------------------------
echo "OK";

?>
