<?php
require_once __DIR__.'/../portal/config.php';

$data = json_decode(file_get_contents("php://input"), true);

$req = [
   'user_id','account_id','broker','balance',
   'equity','daily_dd','max_dd','open_trades'
];

foreach($req as $k){
   if(!isset($data[$k])){
      http_response_code(400);
      echo json_encode(["status"=>"MISSING_FIELD","field"=>$k]);
      exit;
   }
}

$stmt = $conn->prepare("
REPLACE INTO fxh_mt5_accounts 
(user_id,account_id,broker,balance,equity,daily_dd,max_dd,open_trades)
VALUES(?,?,?,?,?,?,?,?)
");

$stmt->bind_param(
   "issdddii",
   $data['user_id'],
   $data['account_id'],
   $data['broker'],
   $data['balance'],
   $data['equity'],
   $data['daily_dd'],
   $data['max_dd'],
   $data['open_trades']
);

$stmt->execute();

echo json_encode(["status"=>"OK"]);
