<?php
session_start();
require_once __DIR__."/../config_webhook.php";
?>
<!DOCTYPE html>
<html>
<head>
<title>FX-HUNTER LIVE COMMAND PANEL</title>

<style>
body{
    background:#05070c;
    color:#0ff;
    font-family:Arial;
}

.panel{
    padding:14px;
    margin:10px;
    border:1px solid #00ffff55;
    box-shadow:0 0 14px #00ffff33;
}

table{
    width:100%;
    border-collapse:collapse;
}

th,td{
    border:1px solid #00ffff44;
    padding:6px;
    text-align:center;
}

th{ background:#06131c; }

input,select,button{
    background:#0b1a24;
    color:#0ff;
    border:1px solid #00ffff55;
    padding:6px;
}

button{
    cursor:pointer;
}
button:hover{
    background:#00ffff22;
}
</style>
</head>

<body>

<h2>⚡ FX-HUNTER — LIVE COMMAND PANEL</h2>

<!-- ========================= -->
<!-- OPEN POSITIONS -->
<!-- ========================= -->

<div class="panel">
<h3>LIVE OPEN POSITIONS</h3>

<table id="positions">
<thead>
<tr>
<th>License</th>
<th>Symbol</th>
<th>Ticket</th>
<th>Side</th>
<th>Lot</th>
<th>PnL</th>
<th>SL</th>
<th>TP</th>
<th>Actions</th>
</tr>
</thead>

<tbody></tbody>
</table>
</div>

<!-- ========================= -->
<!-- MANUAL TRADE PANEL -->
<!-- ========================= -->

<div class="panel">
<h3>MANUAL TRADE EXECUTION</h3>

<form id="tradeForm">

License:
<input id="license" required size="18">

Symbol:
<input id="symbol" value="XAUUSD">

Side:
<select id="side">
<option>BUY</option>
<option>SELL</option>
</select>

Lot:
<input id="lot" type="number" step="0.01" value="0.01">

SL:
<input id="sl" type="number">

TP:
<input id="tp" type="number">

<button type="submit">
🚀 EXECUTE TRADE
</button>

</form>

<div id="trade_result"></div>
</div>

<!-- ========================= -->
<!-- EXECUTION LOG -->
<!-- ========================= -->

<div class="panel">
<h3>EA EXECUTION LOG</h3>
<div id="exec_log" style="max-height:260px;overflow:auto;"></div>
</div>


<script>
const POLL_MS = 2000;

/* --------------------------- */
/* LOAD LIVE POSITIONS */
/* --------------------------- */

function loadPositions(){
 fetch('get_live_positions.php')
 .then(r=>r.json())
 .then(rows=>{

   let html='';

   rows.forEach(p=>{

     html+=`
<tr>
<td>${p.license_key}</td>
<td>${p.symbol}</td>
<td>${p.ticket}</td>
<td>${p.side}</td>
<td>${p.lot}</td>
<td>${p.pnl}</td>
<td>${p.sl}</td>
<td>${p.tp}</td>

<td>
<button onclick="closeFull('${p.license_key}',${p.ticket})">FULL CLOSE</button>
<button onclick="partialClose('${p.license_key}',${p.ticket})">50%</button>
</td>

</tr>
`;

   });

   document.querySelector("#positions tbody").innerHTML = html;

 });
}

/* --------------------------- */
/* LOAD EXEC LOGS */
/* --------------------------- */

function loadLogs(){
 fetch('get_execution_logs.php')
 .then(r=>r.text())
 .then(t=>{
    document.getElementById('exec_log').innerHTML = t;
 });
}


/* --------------------------- */
/* MANUAL TRADE SUBMIT */
/* --------------------------- */

document.getElementById('tradeForm').addEventListener('submit', e=>{

 e.preventDefault();

 let data = new FormData();
 data.append("license", license.value);
 data.append("symbol", symbol.value);
 data.append("side", side.value);
 data.append("lot", lot.value);
 data.append("sl", sl.value);
 data.append("tp", tp.value);

 fetch("send_manual_trade.php",{
    method:'POST',
    body:data
 })
 .then(r=>r.json())
 .then(res=>{
    document.getElementById("trade_result").innerHTML = JSON.stringify(res);
 });

});


/* --------------------------- */
/* TRADE COMMANDS */
/* --------------------------- */

function closeFull(license,ticket){
 sendCommand(license,ticket,'CLOSE_FULL',0);
}

function partialClose(license,ticket){
 sendCommand(license,ticket,'CLOSE_PARTIAL',50);
}

function sendCommand(license,ticket,action,param){
 let data=new FormData();

 data.append("license",license);
 data.append("ticket",ticket);
 data.append("action",action);
 data.append("param",param);

 fetch("send_trade_command.php",{
   method:"POST",
   body:data
 });

}


/* --------------------------- */
/* MAIN LOOP */
/* --------------------------- */

setInterval(()=>{
    loadPositions();
    loadLogs();
},POLL_MS);

loadPositions();
loadLogs();

</script>

</body>
</html>
