<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../middleware/user_auth.php';

$user_id = $_SESSION['user_id'];

$old = $_POST['old_password'];
$new = $_POST['new_password'];
$rep = $_POST['repeat_password'];

if ($new !== $rep) {
    die("Passwords do not match.");
}

$stmt = $conn->prepare("SELECT user_pass FROM fxhai_users WHERE ID=?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$row = $stmt->get_result()->fetch_assoc();

// Verify old password
if (!password_verify($old, $row['user_pass'])) {
    die("Current password incorrect.");
}

$newHash = password_hash($new, PASSWORD_DEFAULT);

// Update
$stmt = $conn->prepare("UPDATE fxhai_users SET user_pass=? WHERE ID=?");
$stmt->bind_param("si", $newHash, $user_id);
$stmt->execute();

header("Location: account.php?password=updated");
exit;
