<?php
define("FXH_PORTAL", true);
$pageTitle = "Account Metrics";

// CONFIG + AUTH
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../middleware/user_auth.php';

// GET LICENSE KEY
$license = $_GET['license'] ?? '';
if ($license == '') {
    die("License key missing.");
}

// SAFE LICENSE
$license = $conn->real_escape_string($license);

// LOAD HEADER + SIDEBAR
require_once __DIR__ . "/includes/header.php";
require_once __DIR__ . "/includes/sidebar.php";
?>

<!-- =============================================================
     NEON METRICS PAGE UI (FRONTEND ONLY — DATA VIA JS)
============================================================== -->

<link rel="stylesheet" href="/portal/user/assets/metrics.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<div class="fxh-main metrics-container">

    <!-- PAGE HEADER -->
    <div class="metrics-header">
        <h1>Account Metrics</h1>
        <div class="metrics-license-tag">
            <span>License:</span> <?= htmlspecialchars($license) ?>
        </div>
    </div>

    <!-- TOP SUMMARY CARDS -->
    <div class="metrics-top-cards">

        <div class="metric-card" id="card-balance">
            <div class="metric-title">Balance</div>
            <div class="metric-value" id="balance-value">$0</div>
        </div>

        <div class="metric-card" id="card-equity">
            <div class="metric-title">Equity</div>
            <div class="metric-value" id="equity-value">$0</div>
        </div>

        <div class="metric-card" id="card-winrate">
            <div class="metric-title">Win Rate</div>
            <div class="metric-circle">
                <canvas id="winRateCircle" width="110" height="110"></canvas>
                <div class="metric-circle-text" id="winrate-text">0%</div>
            </div>
        </div>

    </div>


    <!-- BALANCE / EQUITY CHART -->
    <div class="metrics-box chart-box">
        <div class="chart-header">
            <h2>Balance</h2>

            <div class="chart-tabs">
                <button class="tab-btn active" data-range="daily">Daily</button>
                <button class="tab-btn" data-range="weekly">Weekly</button>
                <button class="tab-btn" data-range="monthly">Monthly</button>
            </div>
        </div>

        <canvas id="balanceChart" height="120"></canvas>
    </div>


    <!-- DAILY SUMMARY + EQUITY CHART -->
    <div class="metrics-two-columns">

        <!-- EQUITY BAR CHART -->
        <div class="metrics-box">
            <h2>Account Equity</h2>
            <canvas id="equityBarChart" height="200"></canvas>

            <div class="equity-stats">
                <div>Highest Equity: <span id="highest-equity">$0</span></div>
                <div>Lowest Equity: <span id="lowest-equity">$0</span></div>
            </div>
        </div>

        <!-- DAILY SUMMARY TABLE -->
        <div class="metrics-box">
            <h2>Daily Summary</h2>

            <table class="metrics-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Balance</th>
                        <th>Equity</th>
                        <th>Result</th>
                    </tr>
                </thead>
                <tbody id="daily-summary-body">
                    <tr><td colspan="4">Loading…</td></tr>
                </tbody>
            </table>

            <div class="pagination" id="dailyPagination"></div>
        </div>

    </div>



    <!-- ACCOUNT INFO + PROGRAM OBJECTIVES -->
    <div class="metrics-two-columns">

        <!-- ACCOUNT INFO -->
        <div class="metrics-box">
            <h2>Account</h2>
            <div class="account-info" id="account-info-box">
                <!-- Filled by JS -->
            </div>
        </div>

        <!-- PROGRAM OBJECTIVES -->
        <div class="metrics-box objectives-box">
            <h2>Program Objectives</h2>

            <div id="objectives-container">
                <!-- JS loads:
                    - Max Daily Loss
                    - Max Overall Loss
                    - Minimum Trading Days
                -->
            </div>
        </div>

    </div>



    <!-- ORDER HISTORY -->
    <div class="metrics-box">
        <h2>Order History</h2>

        <div class="oh-tabs">
            <button class="oh-btn active" data-type="closed">Closed Trades</button>
            <button class="oh-btn" data-type="open">Open Trades</button>

            <select id="symbolFilter" class="oh-select">
                <option value="">All Symbols</option>
            </select>
        </div>

        <table class="metrics-table">
            <thead>
                <tr>
                    <th>Ticket #</th>
                    <th>Symbol</th>
                    <th>Side</th>
                    <th>SL</th>
                    <th>TP</th>
                    <th>Open Time</th>
                    <th>Open Price</th>
                    <th>Close Price</th>
                    <th>Profit</th>
                </tr>
            </thead>
            <tbody id="order-history-body">
                <tr><td colspan="9">Loading…</td></tr>
            </tbody>
        </table>

        <div class="pagination" id="orderPagination"></div>
    </div>

</div>


<!-- JS Controller -->
<script>
const LICENSE_KEY = "<?= $license ?>";
</script>
<script src="/portal/user/assets/metrics.js"></script>

<?php require_once __DIR__ . "/includes/footer.php"; ?>
