<?php
define("FXH_PORTAL", true);

$pageTitle = "Licenses";

require_once __DIR__ . "/../config.php";
require_once __DIR__ . "/../middleware/user_auth.php";
require_once __DIR__ . "/includes/header.php";
require_once __DIR__ . "/includes/sidebar.php";

/* ===============================
   LOAD USER LICENSES
================================ */

$stmt = $conn->prepare("
    SELECT *
    FROM fxh_licenses
    WHERE user_email = ?
    ORDER BY plan, created_at ASC
");

$stmt->bind_param("s", $_SESSION['email']);
$stmt->execute();
$res = $stmt->get_result();

$licenses = [];

while($row = $res->fetch_assoc()){
    $licenses[$row['plan']][] = $row;
}
?>

<style>
.license-wrap{
    max-width:900px;
    margin:40px auto;
}

.plan-box{
    border:1px solid rgba(0,234,255,.35);
    border-radius:18px;
    padding:18px;
    background:rgba(5,10,20,.7);
    box-shadow:0 0 20px rgba(0,234,255,.25);
    margin-bottom:30px;
}

.plan-title{
    text-align:center;
    font-size:28px;
    color:#00eaff;
    margin-bottom:10px;
    letter-spacing:2px;
}

.key{
    text-align:center;
    padding:8px;
    font-size:18px;
    font-weight:500;
    letter-spacing:3px;
    color:#ffd15c;
    cursor:pointer;
}

.key:hover{
    text-shadow:0 0 12px gold;
}

.copy-note{
    opacity:.6;
    text-align:center;
    margin-bottom:8px;
}
</style>

<div class="fxh-main">
<div class="license-wrap">

<h2 class="fxh-title">🔑 MY LICENSE KEYS</h2>
<p style="text-align:center;opacity:.6">Click any key to copy</p>

<?php if(!$licenses): ?>
    <p style="text-align:center;color:#ff4e4e">No licenses found.</p>
<?php endif; ?>


<?php foreach($licenses as $plan => $rows): ?>

<div class="plan-box">

    <div class="plan-title"><?= htmlspecialchars($plan) ?> PLAN</div>

    <div class="copy-note">
        <?= count($rows) ?> License<?= count($rows)>1?'s':'' ?>
    </div>

    <?php foreach($rows as $row): ?>
        <div class="key"
             onclick="navigator.clipboard.writeText(this.innerText)">
             <?= htmlspecialchars($row['license_key']) ?>
        </div>
    <?php endforeach; ?>

</div>

<?php endforeach; ?>


</div>
</div>

<?php require_once __DIR__ . "/includes/footer.php"; ?>
