<?php
define("FXH_PORTAL", true);
$pageTitle = "Trade History";

// Load system
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../middleware/user_auth.php';
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/sidebar.php';
?>

<style>
/* MAIN PAGE */
.fxh-page { 
    margin-left:260px; 
    padding:25px; 
}
@media(max-width:900px){
    .fxh-page { margin-left:0; padding:15px; }
}

/* FILTER BAR */
.fxh-filters {
    display:flex;
    flex-wrap:wrap;
    gap:15px;
    background:#111522;
    padding:18px;
    border-radius:12px;
    border:1px solid #1c2030;
    margin-bottom:20px;
}

.fxh-filter-input,
.fxh-filter-select {
    background:#0d111a;
    border:1px solid #1f2533;
    color:#d8e2ff;
    padding:10px 14px;
    border-radius:8px;
    min-width:160px;
    font-size:14px;
}

.fxh-export-btn {
    background:#00eaff;
    color:#000;
    padding:10px 16px;
    border-radius:8px;
    font-weight:600;
    cursor:pointer;
}

/* TABLE WRAPPER */
.fxh-table-wrap {
    overflow-x:auto;
    border-radius:12px;
    border:1px solid #1c2030;
}

.fxh-history-table {
    width:100%;
    border-collapse:collapse;
    font-size:14px;
}

.fxh-history-table th {
    padding:12px;
    background:#0f1623;
    color:#00eaff;
    border-bottom:1px solid #1f2533;
    white-space:nowrap;
}

.fxh-history-table td {
    padding:10px;
    border-bottom:1px solid #1a2030;
    white-space:nowrap;
}

.fxh-history-table tr:hover {
    background:#121a29;
}

/* PAGINATION */
.fxh-pagination {
    margin-top:18px;
    display:flex;
    gap:10px;
}

.fxh-page-btn {
    background:#0f1623;
    padding:8px 14px;
    border-radius:6px;
    color:#00eaff;
    cursor:pointer;
    border:1px solid #1b2233;
}
.fxh-page-btn.active {
    background:#00eaff;
    color:#000;
}

/* CUSTOM NEON SCROLLBAR */
.fxh-table-wrap::-webkit-scrollbar {
    height:8px;
}
.fxh-table-wrap::-webkit-scrollbar-track {
    background:#0d111a;
    border-radius:10px;
}
.fxh-table-wrap::-webkit-scrollbar-thumb {
    background:#00eaff;
    border-radius:10px;
    box-shadow:0 0 8px #00eaff;
}
</style>

<div class="fxh-page">

    <h2 style="color:#8dc7ff;margin-bottom:15px;">Trade History</h2>

    <!-- FILTER BAR -->
    <div class="fxh-filters">

        <input type="text" id="search" class="fxh-filter-input" placeholder="Search (ticket, symbol, type)">
        
        <input type="date" id="date_from" class="fxh-filter-input">
        <input type="date" id="date_to" class="fxh-filter-input">

        <select id="mt5_filter" class="fxh-filter-select">
            <option value="">All MT5 Accounts</option>
        </select>

        <select id="rows" class="fxh-filter-select">
            <option value="50">50 rows</option>
            <option value="100">100 rows</option>
            <option value="200">200 rows</option>
        </select>

        <button class="fxh-export-btn" onclick="exportCSV()">Export CSV</button>
    </div>

    <!-- TABLE -->
    <div id="historyTable" class="fxh-table-wrap">
        Loading...
    </div>

</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<script>
// LOAD FILTERS
function loadMT5List(){
    $.get("history_api.php?mt5_list=1", function(res){
        $("#mt5_filter").append(res);
    });
}
loadMT5List();

// MAIN LOAD FUNCTION
function loadHistory(page = 1){
    let data = {
        page: page,
        search: $("#search").val(),
        date_from: $("#date_from").val(),
        date_to: $("#date_to").val(),
        mt5: $("#mt5_filter").val(),
        rows: $("#rows").val()
    };

    $.post("history_api.php", data, function(content){
        $("#historyTable").html(content);
    });
}

// AUTO LOAD
loadHistory();

// EVENTS
$("#search, #date_from, #date_to, #mt5_filter, #rows").on("input change", function(){
    loadHistory(1);
});

// PAGINATION CLICK
$(document).on("click", ".fxh-page-btn", function(){
    let p = $(this).data("page");
    loadHistory(p);
});

// CSV EXPORT
function exportCSV(){
    let q = 
        "search=" + $("#search").val() +
        "&date_from=" + $("#date_from").val() +
        "&date_to=" + $("#date_to").val() +
        "&mt5=" + $("#mt5_filter").val();

    window.location = "history_export.php?" + q;
}
</script>
