import { useEffect, useState } from "react";

function App(){

  const [ticks,setTicks] = useState([]);

  useEffect(()=>{

     const ws = new WebSocket("wss://" + window.location.host + "/ws");

     ws.onmessage = e => {

         const data = JSON.parse(e.data);

         if(data.type === "tick"){
            setTicks(prev => [data, ...prev.slice(0,30)]);
         }
     };

  },[]);


  return (
    <div style={{background:"#000",color:"#0ff",height:"100vh",padding:"10px"}}>

        <h2>⚡ FX-HUNTER LIVE TICKS</h2>

        <table border="1" cellPadding="5">
          <thead>
             <tr>
               <th>Symbol</th>
               <th>Bid</th>
               <th>Ask</th>
               <th>Spread</th>
               <th>Time</th>
             </tr>
          </thead>

          <tbody>
            {ticks.map((t,i)=>(
                <tr key={i}>
                    <td>{t.symbol}</td>
                    <td>{t.bid}</td>
                    <td>{t.ask}</td>
                    <td>{t.spread}</td>
                    <td>{new Date(t.time).toLocaleTimeString()}</td>
                </tr>
            ))}
          </tbody>
        </table>

    </div>
  );
}

export default App;
