<?php
require_once "config.php";
fxh_auth_required();
$db = fxh_db();

/* Fetch summary counts */
$total_signals = $db->query("SELECT COUNT(*) AS c FROM fxh_signal_logs")->fetch_assoc()['c'];
$total_trades  = $db->query("SELECT COUNT(*) AS c FROM fxh_trade_logs")->fetch_assoc()['c'];
$active_conns  = $db->query("SELECT COUNT(*) AS c FROM fxh_connections WHERE last_seen > NOW() - INTERVAL 2 MINUTE")->fetch_assoc()['c'];
$errors_today  = $db->query("SELECT COUNT(*) AS c FROM fxh_error_logs WHERE created_at > CURDATE()")->fetch_assoc()['c'];

/* Fetch last 5 connections */
$conns = $db->query("
    SELECT * FROM fxh_connections 
    ORDER BY last_seen DESC 
    LIMIT 5
");

/* Fetch last 5 trades */
$trades = $db->query("
    SELECT * FROM fxh_trade_logs 
    ORDER BY id DESC 
    LIMIT 5
");

?>
<!DOCTYPE html>
<html>
<head>
<title>FXH Portal Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/tailwindcss@3.4.4/dist/tailwind.min.css" rel="stylesheet">
</head>

<body class="bg-gray-900 text-white">

<!-- NAVBAR -->
<div class="bg-gray-800 px-6 py-4 flex justify-between">
    <div class="text-xl font-bold">FXHunter Portal</div>
    <div>
        <a href="connections.php" class="mx-3">Connections</a>
        <a href="trades.php" class="mx-3">Trades</a>
        <a href="signals.php" class="mx-3">Signals</a>
        <a href="logs.php" class="mx-3">Logs</a>
        <a href="manual.php" class="mx-3">Manual Trader</a>
        <a href="settings.php" class="mx-3">Settings</a>
        <a href="logout.php" class="ml-5 bg-red-600 px-3 py-2 rounded">Logout</a>
    </div>
</div>

<!-- MAIN CONTENT -->
<div class="p-6">

    <!-- Metrics -->
    <div class="grid grid-cols-4 gap-6 mb-8">

        <div class="bg-gray-800 p-6 rounded-xl shadow">
            <div class="text-gray-400">Total Signals</div>
            <div class="text-3xl font-bold"><?= number_format($total_signals) ?></div>
        </div>

        <div class="bg-gray-800 p-6 rounded-xl shadow">
            <div class="text-gray-400">Total Trades</div>
            <div class="text-3xl font-bold"><?= number_format($total_trades) ?></div>
        </div>

        <div class="bg-gray-800 p-6 rounded-xl shadow">
            <div class="text-gray-400">Active Connections</div>
            <div class="text-3xl font-bold text-green-400"><?= number_format($active_conns) ?></div>
        </div>

        <div class="bg-gray-800 p-6 rounded-xl shadow">
            <div class="text-gray-400">Errors Today</div>
            <div class="text-3xl font-bold text-red-400"><?= number_format($errors_today) ?></div>
        </div>

    </div>

    <!-- RECENT CONNECTIONS -->
    <div class="bg-gray-800 p-6 rounded-xl shadow mb-8">
        <h2 class="text-xl font-bold mb-4">Latest Connections</h2>
        <table class="w-full text-left">
            <tr class="text-gray-400 border-b border-gray-700">
                <th class="pb-2">License</th>
                <th class="pb-2">Account</th>
                <th class="pb-2">Broker</th>
                <th class="pb-2">Last Seen</th>
            </tr>
            <?php while($row = $conns->fetch_assoc()): ?>
            <tr class="border-b border-gray-700">
                <td class="py-2"><?= $row['license_key'] ?></td>
                <td><?= $row['mt5_account'] ?></td>
                <td><?= $row['broker'] ?></td>
                <td><?= $row['last_seen'] ?></td>
            </tr>
            <?php endwhile; ?>
        </table>
    </div>

    <!-- RECENT TRADES -->
    <div class="bg-gray-800 p-6 rounded-xl shadow">
        <h2 class="text-xl font-bold mb-4">Latest Trades</h2>
        <table class="w-full text-left">
            <tr class="text-gray-400 border-b border-gray-700">
                <th class="pb-2">Ticket</th>
                <th class="pb-2">Symbol</th>
                <th class="pb-2">Type</th>
                <th class="pb-2">Volume</th>
                <th class="pb-2">Profit</th>
            </tr>
            <?php while($tr = $trades->fetch_assoc()): ?>
            <tr class="border-b border-gray-700">
                <td class="py-2"><?= $tr['ticket'] ?></td>
                <td><?= $tr['symbol'] ?></td>
                <td><?= strtoupper($tr['type']) ?></td>
                <td><?= $tr['volume'] ?></td>
                <td class="<?= $tr['profit'] >= 0 ? 'text-green-400' : 'text-red-400' ?>">
                    <?= $tr['profit'] ?>
                </td>
            </tr>
            <?php endwhile; ?>
        </table>
    </div>

</div>

</body>
</html>
