<?php

require_once "/var/www/html/portal/vendor/autoload.php";

use Defuse\Crypto\Crypto;
use Defuse\Crypto\Key;

if (!function_exists('decrypt_lmfwc_license')) {

function decrypt_lmfwc_license(string $cipher): string
{
    if (!$cipher) return '';

    // Already plain
    if (strpos($cipher, 'def5020') !== 0)
        return trim($cipher);

    $keyFile = "/var/www/html/portal/keys/defuse.txt";

    if (!file_exists($keyFile))
        return '';

    $ascii = trim(file_get_contents($keyFile));
    if (!$ascii)
        return '';

    try {
        $key = Key::loadFromAsciiSafeString($ascii);
        $plain = Crypto::decrypt($cipher, $key);
        return trim($plain);
    }
    catch(Throwable $e) {
        return '';
    }
}

}
