<?php
require_once "../config.php";
fxh_auth_required();

$db = fxh_db();
$user = $_SESSION['fxh_user'];

$license_key = bin2hex(random_bytes(16));
$plan = "BRONZE";   // default
$user_email = $user['email'];
$mt5_account = 0;
$active = 1;
$created_at = date("Y-m-d H:i:s");
$expires_at = date("Y-m-d H:i:s", strtotime("+30 days"));

$q = $db->prepare("
    INSERT INTO fxh_licenses 
    (license_key, plan, user_email, mt5_account, active, created_at, expires_at)
    VALUES (?, ?, ?, ?, ?, ?, ?)
");

$q->bind_param(
    "sssisss",
    $license_key, $plan, $user_email, $mt5_account, $active, $created_at, $expires_at
);

$q->execute();

echo json_encode([
    "status"=>"ok",
    "license"=>$license_key,
    "expires"=>$expires_at
]);
?>
