<?php
header("Content-Type: application/json");
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

require_once __DIR__ . "/../config.php";

$mt5 = $_GET['mt5_account'] ?? '';

if (!$mt5) {
    echo json_encode(["status"=>"ERR"]);
    exit;
}

/*
 Sum closed trades for today
*/
$sql = "
    SELECT SUM(profit) as p
    FROM fxh_trade_logs
    WHERE mt5_account = ?
    AND close_time >= CURDATE()
";

$st = $conn->prepare($sql);
$st->bind_param("s", $mt5);
$st->execute();
$res = $st->get_result()->fetch_assoc();

$p = (float)($res['p'] ?? 0);

echo json_encode([
    "status"        => "OK",
    "daily_profit" => number_format($p,2,'.','')
]);
