sudo tee /var/www/html/portal/api/execute_trade.php <<'EOF'
<?php
header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"), true);

if(!$data){
    echo json_encode(["status"=>"ERROR","reason"=>"INVALID_JSON"]);
    exit;
}

$sym  = trim($data["symbol"] ?? "");
$lots = floatval($data["lots"] ?? 0);
$sl   = trim($data["sl"] ?? "");
$tp   = trim($data["tp"] ?? "");
$type = strtoupper(trim($data["type"] ?? ""));

if(!$sym || !$lots || !in_array($type,["BUY","SELL"])){
    echo json_encode(["status"=>"ERROR","reason"=>"PARAMS_MISSING"]);
    exit;
}

/*
 TODO:
 - ADD RISK CHECKS HERE ✅
 - ADD LICENSE CHECK ✅
 - ADD MAX LOT CHECK ✅
*/

// Forward to EA webhook
$url = "https://api.fxhunterai.com/webhook/send_trade_command.php";

$post = json_encode([
    "symbol"=>$sym,
    "lots"=>$lots,
    "sl"=>$sl,
    "tp"=>$tp,
    "type"=>$type
]);

$ch = curl_init($url);
curl_setopt_array($ch,[
  CURLOPT_RETURNTRANSFER=>true,
  CURLOPT_POST=>true,
  CURLOPT_POSTFIELDS=>$post,
  CURLOPT_HTTPHEADER=>["Content-Type: application/json"]
]);

$res = curl_exec($ch);
curl_close($ch);

echo json_encode([
    "status"=>"SENT",
    "payload"=> json_decode($post,true),
    "ea_reply"=>$res
]);
EOF
