<?php
require_once "../config.php";
header('Content-Type: application/json');

$db = fxh_db();

$license = $_GET['license'] ?? '';

if ($license == '') {
    echo json_encode(["status"=>"error","msg"=>"missing_license"]);
    exit;
}

$q = $db->prepare("SELECT active, expires_at FROM fxh_licenses WHERE license_key=? LIMIT 1");
$q->bind_param("s", $license);
$q->execute();
$res = $q->get_result();

if ($res->num_rows == 0) {
    echo json_encode(["status"=>"invalid"]);
    exit;
}

$row = $res->fetch_assoc();

// expired?
if (strtotime($row['expires_at']) < time()) {
    echo json_encode(["status"=>"expired"]);
    exit;
}

// inactive/banned?
if ((int)$row['active'] !== 1) {
    echo json_encode(["status"=>"inactive"]);
    exit;
}

echo json_encode(["status"=>"active"]);
?>
