<?php
require_once __DIR__."/auth.php";

/*
    FX-HUNTER BOOK PROFIT COMMAND DISPATCHER
    ----------------------------------------
    Writes BOOK_PROFIT command directly into EA's polling file.
*/

$user = API_AUTH();

// ---------------------------
// Validate input
// ---------------------------
$license = trim($_POST['license'] ?? '');
$mt5     = trim($_POST['mt5'] ?? '');

if ($license === '' || $mt5 === '') {
    http_response_code(400);
    echo "ERR_MISSING";
    exit;
}

// ---------------------------
// Correct EA signal directory
// ---------------------------
$signalDir = "/var/www/html/webhook/signals";

if (!is_dir($signalDir)) {
    mkdir($signalDir, 0777, true);
}

// ---------------------------
// Correct EA command file
// ---------------------------
$file = $signalDir . "/latest_signal_{$license}.txt";

// ---------------------------
// Write BOOK_PROFIT command
// ---------------------------

$payload = "BOOK_PROFIT\n";
file_put_contents($file, $payload, LOCK_EX);

// ---------------------------
// Return OK to dashboard
// ---------------------------
echo "OK";
exit;
